/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.DpAdminNotebook;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCTabButton;
import jclass.util.JCEnvironment;

public class DpAdmin
extends Applet
implements WindowListener,
AppletContext,
ActionListener {
    private static String helpBrowser;
    private static String helpServer;
    private String serverName;
    private int portNumber;
    private boolean runningAsApplet = true;
    private static ResourceBundle adminRB;
    private DpAdminNotebook notebook;
    private Panel buttons;
    private Button previous;
    private Button next;
    private Panel mainPanel;

    public DpAdmin() {
    }

    public DpAdmin(String string, int n) {
        this.serverName = string;
        this.portNumber = n;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!this.runningAsApplet) {
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public String getAppletInfo() {
        return "DpManager Administration applet version 0.75";
    }

    public Applet getApplet(String string) {
        if (this.runningAsApplet) {
            return super.getAppletContext().getApplet(string);
        }
        return this;
    }

    public Enumeration getApplets() {
        if (this.runningAsApplet) {
            return super.getAppletContext().getApplets();
        }
        Vector<DpAdmin> vector = new Vector<DpAdmin>();
        vector.addElement(this);
        return vector.elements();
    }

    public AppletContext getAppletContext() {
        if (this.runningAsApplet) {
            return super.getAppletContext();
        }
        return this;
    }

    public URL getDocumentBase() {
        if (this.runningAsApplet) {
            return super.getDocumentBase();
        }
        URL uRL = null;
        try {
            uRL = new URL("http:////" + helpServer + "//");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public void showDocument(URL uRL) {
        if (this.runningAsApplet) {
            super.getAppletContext().showDocument(uRL);
            return;
        }
        String string = uRL.toString();
        String[] stringArray = new String[]{helpBrowser, string};
        try {
            Runtime.getRuntime().exec(stringArray);
            return;
        }
        catch (Exception exception) {
            String string2 = String.valueOf(adminRB.getString("s_CouldNotLaunchHelpWebBrowser")) + helpBrowser;
            string2 = String.valueOf(string2) + "\n" + adminRB.getString("s_AdminCommandLineUsage");
            string2 = String.valueOf(string2) + "\n" + adminRB.getString("s_ChangeCommandLine");
            string2 = String.valueOf(string2) + "\n" + adminRB.getString("s_CommandLineExample");
            Frame frame = new Frame();
            new MessageBox(frame, "", string2, true);
            return;
        }
    }

    public void showDocument(URL uRL, String string) {
        if (this.runningAsApplet) {
            super.getAppletContext().showDocument(uRL, string);
            return;
        }
        String string2 = uRL.toString();
        String[] stringArray = new String[]{helpBrowser, string2};
        try {
            Runtime.getRuntime().exec(stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(adminRB.getString("s_CouldNotLaunchHelpWebBrowser")) + helpBrowser);
            System.out.println(adminRB.getString("s_AdminCommandLineUsage"));
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.previous) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n > 0) {
                this.notebook.setFirstVisibleTab(n - 1);
                return;
            }
            this.notebook.setFirstVisibleTab(jCTabButtonArray.length - 1);
            return;
        }
        if (actionEvent.getSource() == this.next) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n < jCTabButtonArray.length - 1) {
                this.notebook.setFirstVisibleTab(n + 1);
                return;
            }
            this.notebook.setFirstVisibleTab(0);
        }
    }

    public void init() {
        String string;
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(new BorderLayout());
        this.notebook = new DpAdminNotebook();
        if (this.serverName == null) {
            this.serverName = this.getParameter("ServerName");
            string = this.getParameter("ServerPort");
            try {
                this.portNumber = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.portNumber = 2099;
            }
        }
        if (this.serverName == null || this.serverName.length() == 0) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
                this.serverName = InetAddress.getByName(string).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.serverName = null;
            }
            if (this.serverName == null || this.serverName.length() == 0) {
                this.serverName = new String("");
            }
        }
        this.notebook.initialize(this.serverName, this.portNumber, this);
        if (JCEnvironment.getBrowser(this) == 3) {
            this.buttons = new Panel();
            this.buttons.setForeground(Color.black);
            this.buttons.setLayout(new FlowLayout());
            this.previous = new Button(adminRB.getString("s_Previous"));
            this.previous.setBackground(Color.lightGray);
            this.previous.addActionListener(this);
            this.next = new Button(adminRB.getString("s_Next"));
            this.next.setBackground(Color.lightGray);
            this.next.addActionListener(this);
            this.buttons.add(this.previous);
            this.buttons.add(this.next);
            this.mainPanel.add("North", this.buttons);
        }
        this.mainPanel.add("Center", this.notebook);
        if (this.runningAsApplet) {
            this.notebook.setPreferredSize(this.getSize().width - 10, this.getSize().height - 30);
            this.add(this.mainPanel);
            this.invalidate();
            this.validate();
        }
    }

    public Insets getInsets() {
        return new Insets(5, 2, 2, 2);
    }

    public static void main(String[] stringArray) {
        try {
            adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
            if (stringArray.length < 2) {
                System.out.println(adminRB.getString("s_AdminCommandLineUsage"));
                return;
            }
            int n = Integer.parseInt(stringArray[1]);
            Traces.initializeTraces(stringArray[0], n);
            helpServer = stringArray[0];
            helpBrowser = stringArray.length >= 3 ? stringArray[2] : "hotjava";
            Frame frame = new Frame(adminRB.getString("s_AdminTitle"));
            DpAdmin dpAdmin = new DpAdmin(stringArray[0], n);
            dpAdmin.runningAsApplet = false;
            frame.addWindowListener(dpAdmin);
            ((Component)frame).setSize(800, 600);
            frame.show();
            dpAdmin.init();
            frame.add(dpAdmin.mainPanel);
            frame.invalidate();
            frame.validate();
            dpAdmin.start();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

